library(reshape2)
library(ggplot2)
library(ggpubr)
library(viridisLite)
library(viridis)
library(cowplot)
args=commandArgs(T)
file1 <- args[1]
data <- read.table(file1,header = T)
mydata <- melt(data,id.vars = "length",variable.name = "type",value.name = "counts")
A <- ggplot(data=mydata,aes(length,counts,fill=type))+geom_bar(stat="identity",position = "stack")+theme_bw()+theme_classic()+scale_y_continuous(limits=c(0,10000),expand = c(0,0))+theme(axis.ticks.x = element_blank())+theme(axis.text.x = element_blank())+xlim(17,36)+xlab("")
A
count <- data
count$counts <- count$A+count$U+count$C+count$G
a <- data.frame(c("A","U","C","G"),c(sum(count$A)/sum(count$counts),sum(count$U)/sum(count$counts),sum(count$C)/sum(count$counts),sum(count$G)/sum(count$counts)))
colnames(a) <- c("type","percentage")
a$percentage <- round(a$percentage,2)

yanse=c("#F8766D","#00BFC4","#C77CFF","#7CAE00")
mylable <- paste(a$type,'(',a$percentage*100,'%',')',sep = '')
q <- ggpie(a,'percentage',fill='type',legend="NA",label = mylable,lab.pos = 'out',lab.font = c(4,'white'),palette =yanse)
p <- ggdraw() +draw_plot(A+theme(legend.justification = "bottom"),0,0,1,1)+draw_plot(q,0.62,0.52,0.5,0.4)
p
p1=p
file2 <- args[2]
data <- read.table(file2,header = T)
mydata <- melt(data,id.vars = "length",variable.name = "type",value.name = "counts")
mydata$counts <- -mydata$counts
A <- ggplot(data=mydata,aes(length,counts,fill=type))+geom_bar(stat="identity",position = "stack")+theme_bw()+theme_classic()+scale_y_continuous(limits=c(-100,0),expand = c(0,0))+xlim(17,36)
A
count <- data
count$counts <- count$A+count$U+count$C+count$G
a <- data.frame(c("A","U","C","G"),c(sum(count$A)/sum(count$counts),sum(count$U)/sum(count$counts),sum(count$C)/sum(count$counts),sum(count$G)/sum(count$counts)))
colnames(a) <- c("type","percentage")
a$percentage <- round(a$percentage,2)

yanse=c("#F8766D","#00BFC4","#C77CFF","#7CAE00")
mylable <- paste(a$type,'(',a$percentage*100,'%',')',sep = '')
q <- ggpie(a,'percentage',fill='type',legend="NA",label = mylable,lab.pos = 'out',lab.font = c(4,'white'),palette =yanse)
p <- ggdraw() +draw_plot(A+theme(legend.justification = "bottom"),0,0,1,1)+draw_plot(q,0.62,0.52,0.5,0.4)
p2 <- p
c <- plot_grid(p1,p2 ,nrow=2,align = "hv")                                                                                                                                                                                                               
c
file3 <- args[3]
pdf(file3,width =4,height = 4)
c
dev.off()
